/* -------------------------------------
| Library: SysEx Forms generator        |
|  Author: Lubos Jerabek (lubos@b0t.cz) |
|    Info: Jan David (info@chd-el.cz)   |
|    Copy: CHD elektroservis s.r.o      |
|    Date: 12.03.2003                   |
| Download: http://www.chd-el.cz/sysex/ |
 ------------------------------------- */
// ---- definice version -------------------------------------------------------------
var VERSION = 1.5;

// ---- definice design array for inline styles --------------------------------------
var SYSEXTABLE_WIDTH   = 0; // table width
var FRMTEXTAREA_WIDTH  = 1; // textarea width
var FRMTEXTAREA_HEIGHT = 2; // textarea height
var FRMSELECT_WIDTH    = 3; // selectbox width

var styles = new Array();        // inline styles array
styles[SYSEXTABLE_WIDTH] = 500;  // default width
styles[FRMTEXTAREA_WIDTH] = 490; // default width
styles[FRMTEXTAREA_HEIGHT] = 80; // default width
styles[FRMSELECT_WIDTH] = 100;   // default width

// ---- form checkbox object definition ------------------------------------------------
function chb() {
	this.frmname = '';
	this.checked = false;
}
// parametry
chb.prototype.set = function(name, checked) {
	this.frmname = name;
	this.checked = checked;
}
// formated output method
chb.prototype.toString = function() {
	if (this.checked==true) check = ' checked'; else check = '';
	var out = '<input type="checkbox" name="'+ this.frmname +'" value="1"' + check +' class="frmcheckbox">\n';
	return out;
}

// ---- form select object definition ------------------------------------------------
function sel() {
	this.vals = new Array();
	this.frmname = '';
	this.selected = false;
}
// names and values generating
sel.prototype.numopt = function(startval, stopval, nameoffset) {
	for (i=startval; i<=stopval; i++) {
		this.vals[this.vals.length] = new Array(i, i + nameoffset);
	}
}
// names and values adding
sel.prototype.addopt = function(val, name) {
	this.vals[this.vals.length] = new Array(val, name);
}
// formated output method
sel.prototype.toString = function() {
	var out = '<select name="'+ this.frmname +'" class="frmselect" style="width:'+ styles[FRMSELECT_WIDTH] +'px;">\n';
	for (var i=0; i<this.vals.length; i++) {
		if (this.vals[i][0]==this.selected) sele = ' selected'; else sele = ''; 
		out += '<option value="'+ this.vals[i][0] +'"'+ sele +'>'+ this.vals[i][1] +'</option>\n';
	}
	out += '</select>\n';
	return out;
}

// ---- sysex ------------------------------------------------------------------------
function sysex() {
	this.sysex = new Array() // jednotlive byty
	this.chsmfrom = 0;
	this.chsmto = 0;
}
// insert byte to field
sysex.prototype.addbyte = function(abyte) {
	this.sysex[this.sysex.length] = abyte;
}
// checksum
sysex.prototype.checksum = function() {
	var checksum = 0;
	for (i=this.chsmfrom; i<=this.chsmto; i++) {
		checksum += Number(this.sysex[i]);
	}
	return (128 - (checksum % 128)) % 128;
}
// convert to HEX string
sysex.prototype.toString = function() {
	var out = '';
	if (document.tr808.HexDel.value == 0) {
		space=' ';
	} else if (document.tr808.HexDel.value == 1) {
		space=', ';
	} else if (document.tr808.HexDel.value == 2) {
		space='; ';
	}
	for (val in this.sysex) {
		if (val==this.sysex.length-1) space='';
		out += toHex(this.sysex[val]) + space;
	}
	return out;
}

// ---- table generator --------------------------------------------------------------
function table() {
	this.cols = new Array(); // table cols names
	this.rows = new Array(); // table rows (this set first)
	this.butok = 'Generate'; // main button ok, default text
	this.butreset = 'Reset'; // main button reset, default text
	this.buthlp = '';        // help file url
	this.frmname = '';       // form name
	this.title = '';         // main table title
}

// add header col
table.prototype.addcol = function(title) {
	this.cols[this.cols.length] = title;
}
// add row
table.prototype.addrow = function() {
	if (arguments.length!=this.cols.length) alert('Error contact tech. support at info@chd-el.cz\nTable cols is: '+ this.cols.length +'!');
	var rowarray = new Array();
	for (i=0; i<this.cols.length; i++) {
		rowarray[i] = arguments[i];
	}
	this.rows[this.rows.length] = rowarray;
}
// formated output method
table.prototype.toString = function() {
	var out;
	
	out  = '<table border="0" cellpadding="3" cellspacing="0" class="sysextable" style="width:'+ styles[SYSEXTABLE_WIDTH] +'px;" align="center">\n';
	out += '<form name="'+ this.frmname +'">\n';
	out += '<tr>\n';
	out += '	<td colspan="'+ this.cols.length +'" class="headname" align="center"><img src="media/logo.gif" width="29" height="14" border="0" alt="CHD Elektroservis">&nbsp;&nbsp;&nbsp;'+ this.title +'</td>\n';
	out += '</tr>\n';
	out += '<tr>\n';
	// header cols
	for (var i=0; i<this.cols.length; i++) {
		out += '	<td class="datarow">'+ this.cols[i] +'</td>\n';
	}
	out += '</tr>\n';
	// data row
	for (var i=0; i<this.rows.length; i++) {
		out += '<tr>\n';
		// data cols
		for (var y=0; y<this.cols.length; y++) {
			out += '	<td class="datarow">'+ this.rows[i][y] +'</td>\n';
		}
		out += '</tr>\n';
	}
	// SysEx textarea
	out += '<tr>\n';
	out += '	<td class="datarow" colspan="'+ this.cols.length +'" align="center">\n';
	out += '		<textarea name="sysex" class="frmtextarea" style="width:'+ styles[FRMTEXTAREA_WIDTH] +'px;height:'+ styles[FRMTEXTAREA_HEIGHT] +'px;"></textarea>\n';
	out += '	</td>\n';
	out += '</tr>\n';
	// Buttons
	out += '<tr>\n';
	out += '	<td class="buttonrow" colspan="'+ this.cols.length +'" align="center">\n';
	if (this.butok != '') { // je-li "this.butok" prazdny, nezobrazi se tlacitko
	out += '		<input type="button" class="btn" value="'+ this.butok +'" onclick="GenerateSysEx();">&nbsp;&nbsp;&nbsp;&nbsp;\n';
	}
	out += '		<input type="button" class="btn" value="'+ this.butreset +'" onclick="document.'+ this.frmname +'.reset();">\n';
	out += '	</td>\n';
	out += '</tr>\n';
	// Helpline
	out += '<tr>\n';
	out += '	<td colspan="'+ this.cols.length +'" class="hlpline" align="center">Remarks:<br>'+ this.hlptxt +'</td>\n';
	out += '</tr>\n';
	// Copyright and help button
	out += '<tr>\n';
	out += '	<td class="backlink">&nbsp;';

	if (this.buthlp != '') { // je-li "this.buthlp" prazdny, nezobrazi se url helpu
	out += '		&nbsp;&nbsp;&nbsp;<a href="javascript:help(\''+ this.buthlp +'\')">Help</a>'
	}

	out += '	</td>\n';

	out += '	<td class="copyright" colspan="'+ (this.cols.length - 1) +'">Copyright &copy; 2015 CHD Elektroservis&nbsp;</td>\n';
	out += '</tr>\n';
	out += '</form>\n';
	out += '</table>\n';

	return out;
}

// ---- main index table object definition --------------------------------------------------------------
function indextable() {
	this.rows = new Array();

}
// parametry
indextable.prototype.addrow = function(model, link, name, device, ver) {
	this.rows[this.rows.length] = Array(model, link, name, device, ver);
}
// formated output method
indextable.prototype.toString = function() {
	var out;
	out  = '<table border="0" cellpadding="3" cellspacing="0" class="sysextable" align="center">';
	out += '	<tr>';
	out += '		<td colspan="4" class="headname" align="center">';
	out += '			<img src="media/logo.gif" width="29" height="14" border="0" alt="CHD Elektroservis">&nbsp;&nbsp;&nbsp;SysEx Messages Generators - v.' + VERSION;
	out += '		</td>';
	out += '	</tr>';
	out += '	<tr>';
	out += '		<td class="headrow">Generator Name</td>';
	out += '		<td class="headrow">Device</td>';
	out += '		<td class="headrow">Model No.</td>';
	out += '		<td class="headrow">Version No.</td>';
	out += '	</tr>';

	// data row
	for (var i=0; i<this.rows.length; i++) {
		out += '	<tr>';
		out += '		<td class="headrow"><a href="'+ this.rows[i][1] +'">'+ this.rows[i][2] +'</a></td>';
		out += '		<td class="datarow">'+ this.rows[i][3] +'</td>';
		out += '		<td class="datarow">'+ this.rows[i][0] +'</td>';
		out += '		<td class="datarow">'+ this.rows[i][4] +'</td>';
		out += '	</tr>';
		out += '<tr>';
	}
	
	out += '	<tr>';
	out += '		<td class="backlink">';
	out += '			<a href="http://www.chd-el.cz/sysex/index.html">On-Line version</a>';
	out += '			<a href="http://www.chd-el.cz/sysex/version.php?current='+ VERSION +'">Newer Version</a>';
	out += '		</td>';
	out += '		<td class="copyright" colspan="3">Copyright &copy; 2009 CHD Elektroservis</td>';
	out += '	</tr>';
	out += '</table>';

	return out;
}

// ---- functions --------------------------------------------------------------------

// Convert dec to hex
function toHex(dec) {
	var hexCharacters = "0123456789ABCDEF";
	if (dec < 0) return "00";
	if (dec > 255) return "FF";
	var i = Math.floor(dec / 16);
	var j = dec % 16;
	if (document.tr808.HexFrm.value == 0) {
		return hexCharacters.charAt(i) + hexCharacters.charAt(j);
	} else if (document.tr808.HexFrm.value == 1) {
		return '0x' + hexCharacters.charAt(i) + hexCharacters.charAt(j);
	} else if (document.tr808.HexFrm.value == 2) {
		return '$' + hexCharacters.charAt(i) + hexCharacters.charAt(j);
	} else if (document.tr808.HexFrm.value == 3) {
		return hexCharacters.charAt(i) + hexCharacters.charAt(j) + 'h';
	} else if (document.tr808.HexFrm.value == 4) {
		return '0' + hexCharacters.charAt(i) + hexCharacters.charAt(j) + 'h';
	}
}

// open help window
function help(file) {
	helpwin = window.open(file ,'helpwin','width=720,height=600,scrollbars=yes,location=no,left=10,top=10,menubar=no,resizable=yes,toolbar=no,status=no');
	if (helpwin) helpwin.focus();
}
